﻿/* Skripte zum NULL-Wert
 * Auszufuehren als Benutzer SCOTT
 */
 
-- Fehlerhafte Ermittlung des Jahresgehalts
select ename mitarbeiter,
       (sal * 12) + comm jahresgehalt
  from emp;
 
-- Korrektur der Jahregeshaltsrechnung
select ename mitarbeiter,
       (sal * 12) + nvl(comm, 120) jahresgehalt
  from emp;
  
-- Verwendung von NULL in Booleschen Ausdrücken
select ename, job, sal, comm, deptno
  from emp
 where comm >= 0
    or deptno = 20;
   
-- Negation des Ausdrucks
select ename, job, sal, comm, deptno
  from emp
 where not (comm >= 0
        or deptno = 20);

-- Auflösung der Negation
select ename, job, sal, comm, deptno
  from emp
 where comm < 0
   and deptno != 20;
   
-- NULL-Problem bei negativen Anfragen
select empno, ename, mgr
  from emp
 where mgr != 7839;
   
-- Anweisung, die keine Zeile liefert
select ename, job, sal
  from emp
 where job not in ('SALESMAN', 'CLERK', null);
 
select ename, job, sal
  from emp
 where job in ('SALESMAN', 'CLERK', null);
 
-- NULL-Werte abfragen
select ename, job, sal
  from emp
 where comm is null;